/**
 ****************************************************************************
 * @file    ipdrv_flash.h
 * @brief   FLASH_DATA Sample Application.
 * @version V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __DFC_H
#define __DFC_H

#ifdef __cplusplus
extern "C" {
#endif                          /* __cplusplus */

/* Includes ------------------------------------------------------------------*/
#include "TMPM4KLA.h"  /*!< TMPM4Ky Group Header file. */
#if defined(__DFC_H)
/** @addtogroup Periph driver
  * @{
  */

/** @defgroup fc fc
  * @brief fc
  * @{
  */


/** @defgroup FLASH_DATA_Exported_Types FLASH_DATA Exported Types
  * @{
  */

/*----------------------------------*/
/** 
 *  @enum   fc_sr0_t
 *  @brief  Enumerated type definition of the FCSR0 register.
 */
/*----------------------------------*/
typedef enum {
    FC_SR0_RDYBSY       = (0x00000001UL)    /*!< 0:Busy, 1:Ready all flash      */
} fc_sr0_t;

/*----------------------------------*/
/** 
 *  @enum   fc_erase_kind_t
 *  @brief  FC Erase Flash Kind structure definenition.
*/
/*----------------------------------*/
typedef enum {
    FC_ERASE_KIND_PAGE      = (0x00000040UL),    /*!< Page Erase                     */
    FC_ERASE_KIND_BLOCK     = (0x00000030UL),    /*!< Block Erase                    */
    FC_ERASE_KIND_AREA      = (0x00000020UL)     /*!< Area Erase                     */
} fc_erase_kind_t;

typedef enum {
    FC_DATA_FLASH_PAGE0  = 0,       /*!< (0x30000000UL), DATA FLASH Page0 */
    FC_DATA_FLASH_PAGE1,        /*!< (0x30000100UL), DATA FLASH Page1 */
    FC_DATA_FLASH_PAGE2,        /*!< (0x30000200UL), DATA FLASH Page2 */
    FC_DATA_FLASH_PAGE3,        /*!< (0x30000300UL), DATA FLASH Page3 */
    FC_DATA_FLASH_PAGE4,        /*!< (0x30000400UL), DATA FLASH Page4 */
    FC_DATA_FLASH_PAGE5,        /*!< (0x30000500UL), DATA FLASH Page5 */
    FC_DATA_FLASH_PAGE6,        /*!< (0x30000600UL), DATA FLASH Page6 */
    FC_DATA_FLASH_PAGE7,        /*!< (0x30000700UL), DATA FLASH Page7 */
    FC_DATA_FLASH_PAGE8,        /*!< (0x30000800UL), DATA FLASH Page8 */
    FC_DATA_FLASH_PAGE9,        /*!< (0x30000900UL), DATA FLASH Page9 */
    FC_DATA_FLASH_PAGE10,       /*!< (0x30000A00UL), DATA FLASH Page10 */
    FC_DATA_FLASH_PAGE11,       /*!< (0x30000B00UL), DATA FLASH Page11 */
    FC_DATA_FLASH_PAGE12,       /*!< (0x30000C00UL), DATA FLASH Page12 */
    FC_DATA_FLASH_PAGE13,       /*!< (0x30000D00UL), DATA FLASH Page13 */
    FC_DATA_FLASH_PAGE14,       /*!< (0x30000E00UL), DATA FLASH Page14 */
    FC_DATA_FLASH_PAGE15,       /*!< (0x30000F00UL), DATA FLASH Page15 */
    FC_DATA_FLASH_PAGE16,       /*!< (0x30001000UL), DATA FLASH Page16 */
    FC_DATA_FLASH_PAGE17,       /*!< (0x30001100UL), DATA FLASH Page17 */
    FC_DATA_FLASH_PAGE18,       /*!< (0x30001200UL), DATA FLASH Page18 */
    FC_DATA_FLASH_PAGE19,       /*!< (0x30001300UL), DATA FLASH Page19 */
    FC_DATA_FLASH_PAGE20,       /*!< (0x30001400UL), DATA FLASH Page20 */
    FC_DATA_FLASH_PAGE21,       /*!< (0x30001500UL), DATA FLASH Page21 */
    FC_DATA_FLASH_PAGE22,       /*!< (0x30001600UL), DATA FLASH Page22 */
    FC_DATA_FLASH_PAGE23,       /*!< (0x30001700UL), DATA FLASH Page23 */
    FC_DATA_FLASH_PAGE24,       /*!< (0x30001800UL), DATA FLASH Page24 */
    FC_DATA_FLASH_PAGE25,       /*!< (0x30001900UL), DATA FLASH Page25 */
    FC_DATA_FLASH_PAGE26,       /*!< (0x30001A00UL), DATA FLASH Page26 */
    FC_DATA_FLASH_PAGE27,       /*!< (0x30001B00UL), DATA FLASH Page27 */
    FC_DATA_FLASH_PAGE28,       /*!< (0x30001C00UL), DATA FLASH Page28 */
    FC_DATA_FLASH_PAGE29,       /*!< (0x30001D00UL), DATA FLASH Page29 */
    FC_DATA_FLASH_PAGE30,       /*!< (0x30001E00UL), DATA FLASH Page30 */
    FC_DATA_FLASH_PAGE31,       /*!< (0x30001F00UL), DATA FLASH Page31 */
    FC_DATA_FLASH_PAGE32        /*!< (0x30002000UL), DATA FLASH Page32 */
} fc_data_flash_page_number_t;

typedef enum {
    FC_DATA_FLASH_BLOCK0  = 0,       /*!< (0x30000000UL), DATA FLASH Block0 */
    FC_DATA_FLASH_BLOCK1,        /*!< (0x30001000UL), DATA FLASH Block1 */
    FC_DATA_FLASH_BLOCK2,        /*!< (0x30002000UL), DATA FLASH Block2 */
    FC_DATA_FLASH_BLOCK3,        /*!< (0x30003000UL), DATA FLASH Block3 */
    FC_DATA_FLASH_BLOCK4,        /*!< (0x30004000UL), DATA FLASH Block4 */
    FC_DATA_FLASH_BLOCK5,        /*!< (0x30005000UL), DATA FLASH Block5 */
    FC_DATA_FLASH_BLOCK6,        /*!< (0x30006000UL), DATA FLASH Block6 */
    FC_DATA_FLASH_BLOCK7         /*!< (0x30007000UL), DATA FLASH Block7 */
} fc_data_flash_block_number_t;

typedef enum {
    FC_DATA_FLASH_AREA0  = 0       /*!< (0x30000000UL), DATA FLASH AREA0 */
} fc_data_flash_area_number_t;

/** @} */
/* End of group FLASH_DATA_Exported_Types */

/** @defgroup FLASH_DATA_Exported_Constants FLASH_DATA Exported Constants
  * @{
  */

#define FC_CODE_FLASH_ADDRESS_TOP   (0x5E000000UL)              /*!< CODE FLASH Address Top */
#define FC_CODE_DATA_ADDRESS_TOP    (0x30000000UL)              /*!< CODE FLASH Address Top */
#define FC_PAGE_SIZE                (0x1000)                    /*!< The number of bytes in a page. */
#define FC_BLOCK_SIZE               (0x8000)                    /*!< The number of bytes in a block. */
#define FC_AREA_SIZE                (0x320000)                  /*!< The number of bytes in a area. */
#define FC_DATA_FLASH_ADDRESS_TOP   (0x30000000UL)              /*!< DATA FLASH Address Top */
#define FC_DATA_PAGE_SIZE                (0x100)                /*!< The number of bytes in a page. */
#define FC_DATA_BLOCK_SIZE               (0x1000)               /*!< The number of bytes in a block. */
#define FC_DATA_AREA_SIZE                (0x8000)              /*!< The number of bytes in a area. */
#define FC_DATA_FLASH_WRITE_SIZE    (sizeof(uint32_t)*4)        /*!< CDATA FLASH WRITE SIZE */

/** @} */
/* End of group FLASH_DATA_Exported_Constants */



/** @weakgroup FLASH_DATA_Exported_FunctionPrototypes
  * @{
  */
uint32_t fc_get_status(fc_sr0_t status);
/* DATA functions */
uint32_t fc_write_data_flash(uint32_t* src_address, uint32_t* dst_address, uint32_t size);
uint32_t fc_erase_page_data_flash(fc_data_flash_page_number_t first_page, uint8_t num_of_pages);
uint32_t fc_blank_check_page_data_flash(fc_data_flash_page_number_t first_page, fc_data_flash_page_number_t last_page);
uint32_t fc_erase_block_data_flash(fc_data_flash_block_number_t first_block, uint8_t num_of_block);
uint32_t fc_blank_check_block_data_flash(fc_data_flash_block_number_t first_block, fc_data_flash_block_number_t last_block);
uint32_t fc_erase_area_data_flash(fc_data_flash_area_number_t area);
uint32_t fc_blank_check_area_data_flash(fc_data_flash_area_number_t area);

/** @} */
/* End of group FLASH_DATA_Exported_FunctionPrototypes */


/** @} */
/* End of group fc */

/** @} */
/* End of group Periph_driver */

#endif                          /* defined(__DFC_H) */

#ifdef __cplusplus
}
#endif                          /* __cplusplus */
#endif                          /* __DFC_H */
