/**
 ****************************************************************************
 * @file    ipdrv_siwdt.h
 * @brief   This file provides all the functions prototypes for M4Kx SIWDT driver.
 * @version V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __IPDRV_SIWDT_H
#define __IPDRV_SIWDT_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "TMPM4KyA.h"
#include "ipdrv_common.h"

/** @addtogroup TX04_Periph_Driver
  * @{
  */

/** @addtogroup SIWDT
  * @{
  */

/** @defgroup SIWDT_Exported_Types
  * @{
  */

/**
  * @brief  SIWDT Init Structure definition
  */

/** @} */
/* End of group SIWDT_Exported_Types */

/** @defgroup SIWDT_Exported_Constants
  * @{
  */

/** @} */
/* End of SIWDT_Exported_Constants */

/** @addtogroup SIWDT_Exported_types
  * @{
  */

    typedef enum {
        SIWDT_DETECT_TIME_EXP_15 = 0U,
        SIWDT_DETECT_TIME_EXP_17 = 1U,
        SIWDT_DETECT_TIME_EXP_19 = 2U,
        SIWDT_DETECT_TIME_EXP_21 = 3U,
        SIWDT_DETECT_TIME_EXP_23 = 4U,
        SIWDT_DETECT_TIME_EXP_25 = 5U,
        SIWDT_DETECT_TIME_EXP_27 = 6U,
        SIWDT_DETECT_TIME_EXP_29 = 7U
    } SIWDT_DetectTime;

#define IS_SIWDT_DETECT_TIME(param)     (((param) == SIWDT_DETECT_TIME_EXP_15) || \
                                         ((param) == SIWDT_DETECT_TIME_EXP_17) || \
                                         ((param) == SIWDT_DETECT_TIME_EXP_19) || \
                                         ((param) == SIWDT_DETECT_TIME_EXP_21) || \
                                         ((param) == SIWDT_DETECT_TIME_EXP_23) || \
                                         ((param) == SIWDT_DETECT_TIME_EXP_25) || \
                                         ((param) == SIWDT_DETECT_TIME_EXP_27) || \
                                         ((param) == SIWDT_DETECT_TIME_EXP_29))

    typedef enum {
        SIWDT_CLOCK_SOURCE_FSYS_DIVIDE_FOUR = 0U,
        SIWDT_CLOCK_SOURCE_INTERNAL_OSCILLATOR_FOR_SYSTEM = 1U,
        SIWDT_CLOCK_SOURCE_INTERNAL_OSCILLATOR_FOR_OFD = 2U
    } SIWDT_ClockSource;

#define IS_SIWDT_CLOCK_SOURCE(param)    (((param) == SIWDT_CLOCK_SOURCE_FSYS_DIVIDE_FOUR)               || \
                                         ((param) == SIWDT_CLOCK_SOURCE_INTERNAL_OSCILLATOR_FOR_SYSTEM) || \
                                         ((param) == SIWDT_CLOCK_SOURCE_INTERNAL_OSCILLATOR_FOR_OFD))

    typedef enum {
        SIWDT_CLEAR_WINDOW_NOT_SPECIFIED = 0U,
        SIWDT_CLEAR_WINDOW_LATTER_A_HALF = 1U,
        SIWDT_CLEAR_WINDOW_LATTER_A_QUARTER = 2U,
    } SIWDT_ClearWindow;

#define IS_SIWDT_CLEAR_WINDOW(param)     (((param) == SIWDT_CLEAR_WINDOW_NOT_SPECIFIED)  || \
                                         ((param) == SIWDT_CLEAR_WINDOW_LATTER_A_HALF)   || \
                                         ((param) == SIWDT_CLEAR_WINDOW_LATTER_A_QUARTER))

    typedef enum {
        SIWDT_OPERATION_INTERRUPT = 0U,
        SIWDT_OPERATION_RESET = 1U,
    } SIWDT_OperationAfterDetectMalFunction;

#define IS_SIWDT_OPERATION_AFTER_DETECT_MALFUNCTION(param)     (((param) == SIWDT_OPERATION_INTERRUPT)  || \
                                                               ((param) == SIWDT_OPERATION_RESET))

    typedef enum {
        SIWDT_NO_PROTECTION = 0U,
        SIWDT_PROTECT_A_MODE = 1U,
        SIWDT_PROTECT_B_MODE = 2U,
    } SIWDT_ProtectMode;

#define IS_SIWDT_PROTECT_MODE(param)     (((param) == SIWDT_NO_PROTECTION)   || \
                                         ((param) == SIWDT_PROTECT_A_MODE)   || \
                                         ((param) == SIWDT_PROTECT_B_MODE))

    typedef enum {
        SIWDT_STATE_STOPPING = 0U,
        SIWDT_STATE_OPERATING = 1U
    } SIWDT_State;

/** @} */
/* End of SIWDT_Exported_types */

/** @defgroup SIWDT_Exported_FunctionPrototypes
  * @{
  */

    Result SIWDT_Enable(void);
    Result SIWDT_SetDetectTime(SIWDT_DetectTime DetectTime);
    Result SIWDT_SetClockSource(SIWDT_ClockSource ClockSource);
    Result SIWDT_SetClearWindow(SIWDT_ClearWindow ClearWindow);
    Result SIWDT_SetOperationAfterDetectMalFunction(SIWDT_OperationAfterDetectMalFunction OperationAfterDetectMalFunction);
    void SIWDT_WriteClearCode(void);
    SIWDT_ProtectMode SIWDT_GetProtectMode(void);
    Result SIWDT_SetProtectMode(SIWDT_ProtectMode ProtectMode);

/** @} */
/* End of SIWDT_Exported_FunctionPrototypes */

/** @} */
/* End of group SIWDT */

/** @} */
/* End of group TX04_Periph_Driver */

#ifdef __cplusplus
}
#endif
#endif                          /* __IPDRV_SIWDT_H */
