/**
 ****************************************************************************
 * @file	main.c
 * @brief	main Functions
 * @version	V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#include <stdlib.h>

#define DEFINE_APP
#include "ipdefine.h"
#undef	DEFINE_APP

#include "ipdrv_siwdt.h"
#include "ipdrv_cg.h"
#include "HPFC_Para.h"
#include "HPFC_drv.h"
#include "D_Para.h"
#include "D_Driver.h"

#include "C_Control.h"
#include "B_User.h"
#include "initial.h"
#include "usercon.h"
#include "dac_drv.h"

#include "ipdrv_siwdt.h"
#include "mcuip_drv.h"

/*===================================================================*
	Proto Type Definition
 *===================================================================*/
void main_loop(void);

/*===================================================================*
	Function
 *===================================================================*/

/**
 *********************************************************************************************
 * @brief		main Routine
 *
 * @return		int
 *********************************************************************************************
 */
int main(void)
{

	/***** Initial Setting *****/
	__disable_irq();									/* DI */

	TSB_CG->FSYSMENA = 0xFFFFFFFF;
	TSB_CG->FSYSMENB = 0xFFFFFFFF;

	init_WDT();											/* Initial setting of WDT */

#if defined(__TYPE_HIGH_VOLT) && defined(__RELAY)
	init_Relay();										/* Initial setting of Relay Port */
#endif /* defined(__TYPE_HIGH_VOLT) && defined(__RELAY) */

	init_TP();											/* Initial setting of Test point port */

#if defined(__USE_ENCODER_FAN) || defined(__USE_ENCODER_COMP)
	init_ENCen();										/* Initial setting of INTENC */
#endif /* __USE_ENCODER */

	init_ADCen();										/* Initial setting of ADC */
	init_PMDen();										/* Initial setting of PMD */
	init_VEen();										/* Initial setting of VE & start */
#if defined(__CONTROL_PFC)
	init_HPFC_Control();
#endif
	B_Motor_Init();										/* Initial setting of the motor control. */
	B_Protect_TemperatureMonitorInit();

#if defined(__USE_DAC)
	init_Dac(DAC_SIO_CH);								/* Initial setting of Dac controller */
#endif /* __USE_DAC */

#if defined(__USE_NBD)
	init_NBD();											/* Initial setting of N.B.D. */
#endif /* __USE_NBD */

#if defined(__USE_microE_COMMUNICATION_FUNC)
	init_uart();
#endif /* __USE_microE_COMMUNICATION_FUNC */

	init_Timer_interval4kH();							/* Initial setting of interval timer. */

	__enable_irq(); 									/* EI */

#if defined(__TYPE_HIGH_VOLT) && defined(__RELAY)
	Relay_On();											/* Turn on Relay */
#endif /* defined(__TYPE_HIGH_VOLT) && defined(__RELAY) */

	SIWDT_WriteClearCode();

	/***** Main Loop *****/
	main_loop();

	return 0;
}

/**
 *********************************************************************************************
 * @brief		main_loop
 *
 * @return		none
 *********************************************************************************************
 */
uint8_t system_poweron;
uint16_t motor_error_cnt;
void main_loop(void)
{
	vector_t* _motor;
	temperature_t* _temp;

	while (1)
	{
#if defined(__CONTROL_PFC)
		SIWDT_WriteClearCode();
		if ((Hpfc.drv.state.flg.emg_ZC == 0) && (system_poweron == 0))
		{
			Motor_comp.drv.state.all = 0;
			Hpfc.drv.state.all = 0;
			Motor_fan.drv.state.all = 0;
			if (motor_error_cnt > cPOWER_CNT)
			{
				motor_error_cnt = 0;
				system_poweron = 1;
			}
		}

		/********************************************************************/
		if (system_poweron == 1)
#endif
		{
			if (M_Main_Counter >= cMAINLOOP_CNT)
			{
				M_Main_Counter = 0;

				/***** Clear WDT *****/
				SIWDT_WriteClearCode();

				/***** HPFC control *****/
#if defined(__CONTROL_PFC)
				HPFC_UserControl();
				HPFC_Control_Main();
#endif
				/***** User motor control   *****/
				B_User_MotorControl();

				/***** User control *****/
#if !defined(__MOTOR_DBGOUT_VECTOR_TIME_INT)&&!defined(__MOTOR_DBGOUT_IDET)&&!defined(__MOTOR_PMDDBG)
				B_Error_DisplayCtrl();
#endif
				_temp = &Temp;

				/***** Motor control  *****/
#if defined(__CONTROL_MOTOR_COMP)
				/* Ch1 */
				_motor = &Motor_comp;

				B_Protect_Temperature(_temp, _motor);
#if defined(__USE_VE_COMP)
				D_SetZeroCurrentByVE(_motor, TSB_VE1);				/* Get Zero current */
#else
				D_SetZeroCurrent(_motor);							/* Get Zero current */
#endif
				C_Control_Ref_Model_1(_motor);						/* Change of stage */
				C_Common(_motor);									/* Stage Functions */
				C_Stage_Stop(_motor);								/* Stop */
				C_Stage_Emergency(_motor);							/* Emergency */
				C_Stage_Bootstrap(_motor);							/* Bootstrap */
				C_Stage_Initposition_1(_motor);						/* Positioning */
				C_Stage_Force_1(_motor);							/* Force commutation */
				C_Stage_Change_up(_motor);							/* Change up */
				C_Stage_Steady_A(_motor);							/* Normal RUN A (Speed control by currnt) */
#endif /* __CONTROL_MOTOR_COMP */

#if defined(__CONTROL_MOTOR_FAN)
				/* Ch0 */
				_motor = &Motor_fan;

#if defined(__USE_VE_FAN)
				D_SetZeroCurrentByVE(_motor, TSB_VE0);				/* Get Zero current */
#else
				D_SetZeroCurrent(_motor);							/* Get Zero current */
#endif
				C_Control_Ref_Model_0(_motor);						/* Change of stage */
				C_Common(_motor);									/* Stage Functions */
				C_Stage_Stop(_motor);								/* Stop */
				C_Stage_Emergency(_motor);							/* Emergency */
				C_Stage_Bootstrap(_motor);							/* Bootstrap */
				C_Stage_Initposition_0(_motor);						/* Positioning */
				C_Stage_Force_0(_motor);							/* Force commutation */
				C_Stage_Change_up(_motor);							/* Change up */
				C_Stage_Steady_A(_motor);							/* Normal RUN A (Speed control by currnt) */
#endif /* defined(__CONTROL_MOTOR_FAN) */
#if defined(__USE_microE_COMMUNICATION_FUNC)
				timer_count();
				uart_control();
#endif	/* __USE_microE_COMMUNICATION_FUNC */
			}
		}
	}
}

/**
  * @brief  Deal with the error parameter
  * @param  file: Pointer to the file where the error parameter locates
  * @param  line: Number of the line in which the error parameter locates
  * @retval None
  */
#ifdef DEBUG
void assert_failed(char *file, int32_t line)
{
	while (1)
	{
		__NOP();
	}
}
#endif

/*********************************** END OF FILE ******************************/
