/**
 ****************************************************************************
 * @file	interrupt.h
 * @brief	Interrupt Functions for A-VE Plus
 * @version	V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _INTERRUPT_H
#define _INTERRUPT_H

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif

/*===================================================================*
      Proto Type Definition
 *===================================================================*/
EXTERN void	INT_interval_4kHz(void);
EXTERN void INT_VectorControlByVE_FAN(TSB_PMD_TypeDef* const PMDx, vector_t* const _motor, TSB_VE_TypeDef * const VEx);
EXTERN void INT_VectorControlByVE_COMP(vector_t* const _motor, TSB_VE_TypeDef * const VEx);
EXTERN void INT_VectorControlBySoft_FAN(vector_t* const _motor, TSB_PMD_TypeDef* const PMDx);
EXTERN void INT_VectorControlBySoft_COMP(vector_t* const _motor, TSB_PMD_TypeDef* const PMDx);
#if defined(__USE_microE_COMMUNICATION_FUNC)
EXTERN void INT_uart0rx();
EXTERN void INT_uart0tx();
#endif /* __USE_microE_COMMUNICATION_FUNC */
#undef EXTERN
#endif /*  _INTERRUPT_H */

/*************************** END OF FILE **************************************/
