/**
 ****************************************************************************
 * @file:    system_int.c
 * @brief:   System Interrupt Functions for TOSHIBA 'TMPM4K' Device Series for A-VE+
 * @version: V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#include "ipdefine.h"
#include "D_Para.h"
#include "HPFC_drv.h"
#include "interrupt.h"

#include "B_User.h"
#include "dac_drv.h"
#include "usercon.h"
#include "system_int.h"


#if defined(__MOTOR_DBGOUT_VECTOR_TIME_INT)
#define	DBO_VE0_HIGH		(TSB_PC_DATA_PC2 = 1)
#define	DBO_VE0_LOW			(TSB_PC_DATA_PC2 = 0)
#define	DBO_VE1_HIGH		(TSB_PC_DATA_PC3 = 1)
#define	DBO_VE1_LOW			(TSB_PC_DATA_PC3 = 0)
#define	DBO_VE2_HIGH		(TSB_PA_DATA_PA2 = 1)
#define	DBO_VE2_LOW			(TSB_PA_DATA_PA2 = 0)
#else  /* defined(__MOTOR_DBGOUT_VECTOR_TIME_INT) */
#define	DBO_VE0_HIGH		/*  */
#define	DBO_VE0_LOW			/*  */
#define	DBO_VE1_HIGH		/*  */
#define	DBO_VE1_LOW			/*  */
#define	DBO_VE2_HIGH		/*  */
#define	DBO_VE2_LOW			/*  */
#endif /* defined(__MOTOR_DBGOUT_VECTOR_TIME_INT) */

#if defined(__COM_DBGOUT_TIME_INT)
#define	DBO_DAC_HIGH		(TSB_PC_DATA_PC2 = 1)
#define	DBO_DAC_LOW			(TSB_PC_DATA_PC2 = 0)
#define	DBO_TXD_HIGH		(TSB_PC_DATA_PC3 = 1)
#define	DBO_TXD_LOW			(TSB_PC_DATA_PC3 = 0)
#define	DBO_RXD_HIGH		(TSB_PA_DATA_PA2 = 1)
#define	DBO_RXD_LOW			(TSB_PA_DATA_PA2 = 0)
#define	DBO_4kH_HIGH		(TSB_PU_DATA_PU5 = 1)
#define	DBO_4kH_LOW			(TSB_PU_DATA_PU5 = 0)
#else  /* defined(__COM_DBGOUT_TIME_INT) */
#define	DBO_DAC_HIGH		/*  */
#define	DBO_DAC_LOW			/*  */
#define	DBO_TXD_HIGH		/*  */
#define	DBO_TXD_LOW			/*  */
#define	DBO_RXD_HIGH		/*  */
#define	DBO_RXD_LOW			/*  */
#define	DBO_4kH_HIGH		/*  */
#define	DBO_4kH_LOW			/*  */
#endif /* defined(__COM_DBGOUT_TIME_INT) */

void NMI_Handler(void)
{}

void HardFault_Handler(void)
{}

void MemManage_Handler(void)
{}

void BusFault_Handler(void)
{}

void UsageFault_Handler(void)
{}

void SVC_Handler(void)
{}

void DebugMon_Handler(void)
{}

void PendSV_Handler(void)
{}

void SysTick_Handler(void)
{}

void INT00_IRQHandler(void)
{}

void INT01_IRQHandler(void)
{}

void INT02_IRQHandler(void)
{}

void INT03_IRQHandler(void)
{}

void INT04_IRQHandler(void)
{}

void INT05_IRQHandler(void)
{}

void INT06_IRQHandler(void)
{}

void INT07_IRQHandler(void)
{}

void INT08_IRQHandler(void)
{}

void INT09_IRQHandler(void)
{}

void INT10_IRQHandler(void)
{}

void INT11_IRQHandler(void)
{}

void INT12_IRQHandler(void)
{}

void INT13_IRQHandler(void)
{}

#if (defined(__TMPM4KNA_H__))
void INT14_IRQHandler(void)
{}

void INT15_IRQHandler(void)
{}

void INT16_IRQHandler(void)
{}

void INT17_IRQHandler(void)
{}

void INT18_IRQHandler(void)
{}

#endif
void INT21_IRQHandler(void)
{}

void INTVCN0_IRQHandler(void)
{
#if (defined(__CONTROL_MOTOR_FAN) && defined(__USE_VE_FAN))
	DBO_VE0_HIGH;
	INT_VectorControlByVE_FAN(TSB_PMD0,&Motor_fan, TSB_VE0);
	DBO_VE0_LOW;
	__DSB();				/* for ARM processor errata 838469 */
#endif /* defined(__CONTROL_MOTOR_FAN) && defined(__USE_VE_FAN) */
}

void INTVCT0_IRQHandler(void)
{}

void INTEMG0_IRQHandler(void)
{}

void INTEMG1_IRQHandler(void)
{}

void INTEMG2_IRQHandler(void)
{}

void INTOVV0_IRQHandler(void)
{}

void INTOVV1_IRQHandler(void)
{}

void INTOVV2_IRQHandler(void)
{}

void INTPWM0_IRQHandler(void)
{}

void INTPWM1_IRQHandler(void)
{}

void INTPWM2_IRQHandler(void)
{}
#if defined(__TMPM4KNA_H__)
void INTENC00_IRQHandler(void)
{}

void INTENC01_IRQHandler(void)
{}

void INTENC10_IRQHandler(void)
{}

void INTENC11_IRQHandler(void)
{}
#endif
void INTENC20_IRQHandler(void)
{}

void INTENC21_IRQHandler(void)
{}
#if (defined(__TMPM4KNA_H__) || defined(__TMPM4KLA_H__))
void INTADAPDA_IRQHandler(void)
#else
void INTADPDA_IRQHandler(void)
#endif
{}

#if (defined(__TMPM4KNA_H__) || defined(__TMPM4KLA_H__))
void INTADBPDB_IRQHandler(void)
#else
void INTADPDB_IRQHandler(void)
#endif
{
#if (defined(__CONTROL_MOTOR_COMP) && !defined(__USE_VE_COMP))
	DBO_VE1_HIGH;
	INT_VectorControlBySoft_COMP(&Motor_comp, TSB_PMD1);
	DBO_VE1_LOW;
	__DSB();				/* for ARM processor errata 838469 */
#endif /* defined(__CONTROL_MOTOR_COMP) && !defined(__USE_VE_COMP) */
}

#if (defined(__TMPM4KNA_H__) || defined(__TMPM4KLA_H__))	/* ==================================== */
void INTADAPDB_IRQHandler(void)
{}

void INTADACP0_IRQHandler(void)
{}

void INTADACP1_IRQHandler(void)
{}

void INTADATRG_IRQHandler(void)
{}

void INTADASGL_IRQHandler(void)
{}

void INTADACNT_IRQHandler(void)
{}

void INTADBPDA_IRQHandler(void)
{}

void INTADBCP0_IRQHandler(void)
{}

void INTADBCP1_IRQHandler(void)
{}

void INTADBTRG_IRQHandler(void)
{}

void INTADBSGL_IRQHandler(void)
{}

void INTADBCNT_IRQHandler(void)
{}

void INTADCPDA_IRQHandler(void)
{}

void INTADCPDB_IRQHandler(void)
{
#if defined(__CONTROL_PFC)
	DBO_VE2_HIGH;
	HPFC_INT_ADC_Fin();
	DBO_VE2_LOW;
	__DSB();				/* for ARM processor errata 838469 */
#endif /* defined(__CONTROL_PFC) */
}

void INTADCCP0_IRQHandler(void)
{}

void INTADCCP1_IRQHandler(void)
{}

void INTADCTRG_IRQHandler(void)
{}

void INTADCSGL_IRQHandler(void)
{}

void INTADCCNT_IRQHandler(void)
{}
#else	/* ==================================== */
void INTADPDC_IRQHandler(void)
{}

void INTADPDD_IRQHandler(void)
{}

void INTADPFLG_IRQHandler(void)
{}

void INTADCPA_IRQHandler(void)
{}

void INTADCPB_IRQHandler(void)
{}

void INTADTRG_IRQHandler(void)
{}

void INTADSGL_IRQHandler(void)
{}

void INTADCNT_IRQHandler(void)
{}
#endif	/* ==================================== */
void INTSC0RX_IRQHandler(void)
{
#if defined(__USE_microE_COMMUNICATION_FUNC)
	DBO_RXD_HIGH;
	INT_uart0rx();
	DBO_RXD_LOW;
	__DSB();				/* for ARM processor errata 838469 */
#endif /* __USE_microE_COMMUNICATION_FUNC */
}

void INTSC0TX_IRQHandler(void)
{
#if defined(__USE_microE_COMMUNICATION_FUNC)
	DBO_TXD_HIGH;
	INT_uart0tx();
	DBO_TXD_LOW;
	__DSB();				/* for ARM processor errata 838469 */
#endif /* __USE_microE_COMMUNICATION_FUNC */
}

void INTSC0ERR_IRQHandler(void)
{}

void INTSC1RX_IRQHandler(void)
{}

void INTSC1TX_IRQHandler(void)
{
#if (defined(__TMPM4KN_H__)||defined(__TMPM4KNA_H__) || defined(__TMPM4KLA_H__))
#if defined(__USE_DAC)
	DBO_DAC_HIGH;
	DacWriteContinue(DAC_SIO_CH);
	DBO_DAC_LOW;
	__DSB();				/* for ARM processor errata 838469 */
#endif /* __USE_DAC */
#endif
}

void INTSC1ERR_IRQHandler(void)
{}

void INTSC2RX_IRQHandler(void)
{}

void INTSC2TX_IRQHandler(void)
{}

void INTSC2ERR_IRQHandler(void)
{}
#if defined(__TMPM4KNA_H__)
void INTSC3RX_IRQHandler(void)
{}

void INTSC3TX_IRQHandler(void)
{}

void INTSC3ERR_IRQHandler(void)
{}
#endif
#if (defined(__TMPM4KNA_H__) || defined(__TMPM4KLA_H__))
void INTI2C0NST_IRQHandler(void)
{}

void INTI2C0ATX_IRQHandler(void)
{}

void INTI2C0BRX_IRQHandler(void)
{}

void INTI2C0NA_IRQHandler(void)
{}

void INTI2C1NST_IRQHandler(void)
{}

void INTI2C1ATX_IRQHandler(void)
{}

void INTI2C1BRX_IRQHandler(void)
{}

void INTI2C1NA_IRQHandler(void)
{}
#elif
void INTI2C0_IRQHandler(void)
{}

void INTI2C0AL_IRQHandler(void)
{}

void INTI2C0BF_IRQHandler(void)
{}

void INTI2C0NACK_IRQHandler(void)
{}

void INTI2C1_IRQHandler(void)
{}

void INTI2C1AL_IRQHandler(void)
{}

void INTI2C1BF_IRQHandler(void)
{}

void INTI2C1NACK_IRQHandler(void)
{}

void INTCANGLB_IRQHandler(void)
{}

void INTCANRXD_IRQHandler(void)
{}

void INTCANTXD_IRQHandler(void)
{}
#endif
void INTT32A00AC_IRQHandler(void)
{}

void INTT32A00ACCAP0_IRQHandler(void)
{}

void INTT32A00ACCAP1_IRQHandler(void)
{}

void INTT32A00B_IRQHandler(void)
{}

void INTT32A00BCAP0_IRQHandler(void)
{}

void INTT32A00BCAP1_IRQHandler(void)
{}

void INTT32A01AC_IRQHandler(void)
{
	DBO_4kH_HIGH;
	INT_interval_4kHz();
	DBO_4kH_LOW;
	__DSB();	
}

void INTT32A01ACCAP0_IRQHandler(void)
{}

void INTT32A01ACCAP1_IRQHandler(void)
{}

void INTT32A01B_IRQHandler(void)
{}

void INTT32A01BCAP0_IRQHandler(void)
{}

void INTT32A01BCAP1_IRQHandler(void)
{}

void INTT32A02AC_IRQHandler(void)
{}

void INTT32A02ACCAP0_IRQHandler(void)
{}

void INTT32A02ACCAP1_IRQHandler(void)
{}

void INTT32A02B_IRQHandler(void)
{}

void INTT32A02BCAP0_IRQHandler(void)
{}

void INTT32A02BCAP1_IRQHandler(void)
{}

void INTT32A03AC_IRQHandler(void)
{}

void INTT32A03ACCAP0_IRQHandler(void)
{}

void INTT32A03ACCAP1_IRQHandler(void)
{}

void INTT32A03B_IRQHandler(void)
{}

void INTT32A03BCAP0_IRQHandler(void)
{}

void INTT32A03BCAP1_IRQHandler(void)
{}

void INTT32A04AC_IRQHandler(void)
{}

void INTT32A04ACCAP0_IRQHandler(void)
{}

void INTT32A04ACCAP1_IRQHandler(void)
{}

void INTT32A04B_IRQHandler(void)
{}

void INTT32A04BCAP0_IRQHandler(void)
{}

void INTT32A04BCAP1_IRQHandler(void)
{}

void INTT32A05AC_IRQHandler(void)
{}

void INTT32A05ACCAP0_IRQHandler(void)
{}

void INTT32A05ACCAP1_IRQHandler(void)
{}

void INTT32A05B_IRQHandler(void)
{}

void INTT32A05BCAP0_IRQHandler(void)
{}

void INTT32A05BCAP1_IRQHandler(void)
{}
#if (defined(__TMPM4KNA_H__) || defined(__TMPM4KLA_H__))
void INTPARI0_IRQHandler(void)
{}

void INTPARI1_IRQHandler(void)
{}
#else
void INTPARI_IRQHandler(void)
{}
#endif

void INTDMACTC_IRQHandler(void)
{}

void INTDMACERR_IRQHandler(void)
{}
#if (defined(__TMPM4KNA_H__) || defined(__TMPM4KLA_H__) )
#else
void INTRTC_IRQHandler(void)
{}
#endif

void INTFLCRDY_IRQHandler(void)
{}

void INTFLDRDY_IRQHandler(void)
{}


/*********************************** END OF FILE ******************************/
