/**
 ****************************************************************************
 * @file	 D_Para_Comp.h
 * @brief	 Motor vector control Parameter Header File for COMP
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _D_PARA_COMP_H
#define _D_PARA_COMP_H
#undef __TYPE_LOW_VOLT
#undef __TYPE_HIGH_VOLT
#undef USE_FAN_MOTOR

/*===================================================================*
	  Select Board type
 *===================================================================*/
/* #define		__TYPE_LOW_VOLT */																		/* Low voltage board */
#define __TYPE_HIGH_VOLT /* High voltage board */

/*===================================================================*
	  Select parts
 *===================================================================*/
/* #define		__USE_ENCODER_COMP	*/																	/* If define __USE_ENCODER, use encoder */
/* #define		__USE_VE_COMP		*/																	/* If define __USE_VE, use Vector Engine */

/*===================================================================*
	  Board Parameter Definition
 *===================================================================*/

/******** A/C 3in1 High voltage board **********************/
#if defined(__TYPE_HIGH_VOLT)			

/* High/Low side driver logic */
#define cPOLH_COMP						(1)			/* High side	 0:Low active, 1:High active */
#define cPOLL_COMP						(1)			/* Low	side	 0:Low active, 1:High active */

/* V MAX */
#define cV_MAX_COMP 					(cV_MAX_FAN)	/* [V] Input voltage(Vdc)  at ADC =0xFFF0(5V) */

/* A MAX */
#define cA_MAX_COMP 					(22.50f)	/* [A] Input current(Iabc) at ADC =0xFFF0(5V) */
#endif

/* Current detection Type */
#define cSHUNT_TYPE_COMP				(1)			/* 1 : 1-shunt, 3 : 3-shunt */
#define cBOOT_TYPE_COMP 				(cBoot_v)	/* cBoot_i : Current control, cBoot_v: Volt control */

#define cSHUNT_ZERO_OFFSET_COMP 		(2.5f)		/* [V] Shunt ad offset voltage (shunt ad voltage of 0A) */

/* AD Channel */
#if !defined(__USE_INAMP_COMP)
#define cADCH_CURRENT_U_COMP			(0)			/* AD channel for U-phase current of 3shunt */
#define cADCH_CURRENT_V_COMP			(1)			/* AD channel for V-phase current of 3shunt */
#define cADCH_CURRENT_W_COMP			(2)			/* AD channel for W-phase current of 3shunt */
#define cADCH_CURRENT_IDC_COMP			(8)			/* UnitB-8 */	/* AD Channel for DC current of 1shunt */
#else
#define cADCH_CURRENT_U_COMP			(0)			/* AD channel for U-phase current of 3shunt */
#define cADCH_CURRENT_V_COMP			(1)			/* AD channel for V-phase current of 3shunt */
#define cADCH_CURRENT_W_COMP			(2)			/* AD channel for W-phase current of 3shunt */
#define cADCH_CURRENT_IDC_COMP			(8)			/* UnitB-8 */	/* AD Channel for DC current of 1shunt */
#endif /* __USE_INAMP_COMP */

#define cADCH_VDC_COMP					(9)						/* UnitA-9 */	/* AD Channel for power supply voltage */

/* Over current */
#define cOVC_COMP						(9.0f)					/* [A] Over current  */

/* Over voltage */
#define cVDC_MINLIM_COMP				(100)					/* [V] Vdc min limit */
#define cVDC_MAXLIM_COMP				(cV_MAX_COMP - 1.0f)	/* [V] Vdc max limit */

/*===================================================================*
	  Motor Parameter Definition
 *===================================================================*/
#if defined(__TYPE_HIGH_VOLT)			
#define USE_COMP_MOTOR
#endif

/* PWM Parameter */
#if defined(USE_COMP_MOTOR)
#define cPWMPRD_COMP					(154.0f)		/* [us] PWM Period */
#define cDEADTIME_COMP					(2.0f)			/* [us] Dead time */
#define cREPTIME_COMP					(1)				/* Repeat time */
#endif

/* External specification */
#if defined(USE_COMP_MOTOR)
#define cSPEED_ACT_COMP 				(10.0f)			/* [Hz or RPM] Target speed of motor */
#endif

#if defined(USE_COMP_MOTOR)
#define	cID_ST_USER_ACT_COMP			(1.6f)			/* [A] Start current (Id) */
#define	cIQ_ST_USER_ACT_COMP			(0.413f)		/* [A] Start current (Iq) */
#endif

/* Motor Parameter */
#if defined(USE_COMP_MOTOR)
#define cMOTOR_R_COMP					(1.139f)		/* [Ohm] Winding resistance */
#define cMOTOR_LQ_COMP					(3.142f)		/* [mH] q-axis inductance */
#define cMOTOR_LD_COMP					(cMOTOR_LQ_COMP)/* [mH] d-axis inductance */
#define cPOLE_COMP						(8)				/* [Pole] Poles of the motor */
#define cPOLEPAIR_COMP					(cPOLE_COMP / 2)
#endif

#define cIQ_ADJ 						(10.0f)

/* Control Gain constant */
#if defined(USE_COMP_MOTOR)
#define cID_KP_COMP						(1.3423f)		/* [V/A]  d-axis low speed current control Proportinal gain */
#define cID_KI_COMP						(366.69f)		/* [V/As] d-axis low speed current control Integral gain */

#define cIQ_KP_COMP						(cID_KP_COMP)	/* [V/A]  q-axis low speed current control Proportinal gain */
#define cIQ_KI_COMP						(cID_KI_COMP)	/* [V/As] q-axis low speed current control Integral gain */
#endif

#if defined(USE_COMP_MOTOR)
#define cPOSITION_KP_COMP 				(232.08099f/50)	/* [Hz/V]  Position estimation low speed Proportinal gain (Kp) */
#define cPOSITION_KI_COMP 				(0.11826f*4)	/* [Hz/Vs] Position estimation low speed Integral gain (Ki) */
#define cSPEED_KP_COMP					(0.07049f)		/* [A/Hz]  Speed Control low speed Proportinal gain */
#define cSPEED_KI_COMP					(0.02726f)		/* [A/Hzs] Speed Control low speed Integral gain */
#endif

#define cSPD_PI_PRD_COMP				(1)				/* Speed PI period */

#if defined(USE_COMP_MOTOR)
#define cFCD_UD_LIM_COMP				(10.0f)			/* [Hz/s] Limitation of the increase value (Forced Stage) */
#define cSTD_UP_LIM_COMP				(10.0f)			/* [Hz/s] Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP2				(10.0f)			/* [Hz/s] Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP3				(10.0f)			/* [Hz/s] Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP4				(10.0f)			/* [Hz/s] Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP_EXH			(10.0f)			/* [Hz/s] Exhaust Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP_HVMOS			(10.0f)			/* [Hz/s] HVMOS Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP_IGBT			(10.0f)			/* [Hz/s] IGBT Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP_DIODE			(10.0f)			/* [Hz/s] DIODE Limitation of the increase value (Steady Stage) */
#define cSTD_UP_LIM_COMP_OUTPIPE		(10.0f)			/* [Hz/s] Outpipe Limitation of the increase value (Steady Stage) */


#define cSTD_DW_LIM_COMP				(10.0f)			/* [Hz/s] Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP2				(10.0f)			/* [Hz/s] Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP3				(10.0f)			/* [Hz/s] Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP_S1_EXH 		(10.0f)			/* [Hz/s]Exhaust stage1 Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP_S1_HVMOS		(10.0f)			/* [Hz/s]HVMOS stage1 Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP_S1_IGBT		(10.0f)			/* [Hz/s]IGBT stage1 Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP_S1_DIODE		(10.0f)			/* [Hz/s]DIOSE stage1 Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP_S1_OUTPIPE 	(10.0f)			/* [Hz/s] Outpipe stage1 Limitation of the decrease value (Steady Stage) */
#define cSTD_DW_LIM_COMP_S2_EXH 		(10.0f)			/* [Hz/s] Exhaust stage2 acc.Select max value of Normal decrease acc and over temp decrease acc*/
#define cSTD_DW_LIM_COMP_S2_HVMOS		(10.0f)			/* [Hz/s] HVMOS stage2 acc.Select max value of Normal decrease acc and over temp decrease acc */
#define cSTD_DW_LIM_COMP_S2_IGBT		(10.0f)			/* [Hz/s] IGBT stage2 acc.Select max value of Normal decrease acc and over temp decrease acc */
#define cSTD_DW_LIM_COMP_S2_DIODE		(10.0f)			/* [Hz/s] DIODE stage2 acc.Select max value of Normal decrease acc and over temp decrease acc */
#define cSTD_DW_LIM_COMP_S2_OUTPIPE 	(10.0f)			/* [Hz/s]Outpipe stage2 acc.Select max value of Normal decrease acc and over temp decrease acc */
#define cACCPOINT						(80)			/* [HZ] Acc change point */
#endif

#define cBOOT_LEN_COMP					(0.5f)			/* [s] Time of Bootstrap Stage */
#define cINIT_LEN_COMP					(2.0f)			/* [s] Time of Positioning Stage */
#define cINIT_WAIT_LEN_COMP 			(2.0f)			/* [s] Time of Positioning wait time */
#define cGOUP_DELAY_LEN_COMP			(0.01f)			/* [s] Time of Change-up delay time */

#if defined(USE_COMP_MOTOR)
#define cHZ_MAX_COMP					(400.0)			/* [Hz] Maximum speed of motor */
#define cHZ_MIN_COMP					(110.0f)		/* [Hz] Minimam speed of motor */
														/* When set cHZ_MIN > S_speed_actx, not move Stage from Force */
#endif

#define cHZ_E_NORMAL_COMP				(333.0f)			/* [Hz]Comp Running max value */
#define cHZ_M_NORMAL_COMP				(cHZ_E_NORMAL_COMP / cPOLEPAIR_COMP) /* [RPS]Comp Running max value */

#define cHZ_SPWM_COMP					(100.0f)		/* [Hz] PWM mode change speed */
#define cMAXPLS_COMP 					(cPWMPRD_COMP*0.9f)	/* [us] Maximum Pulse (for 1shunt shift2) */
#define cMINPLS_COMP					(1.5f)/* (4.0f) */	/* [us] Minimum Pulse (for 1shunt normal) */
#define cSHIFT0 						(0)				/* Power value filter level tmp */
#define cSHIFT1 						(4)				/* Ib filter shift value tmp */
#define cSHIFT2 						(2)				/* Ia filter shift value tmp */
#define cSHIFT3 						(1)				/* Change based on Board noise level */
#define cSHIFT4 						(2)				/* Vac_eff value filter level tmp */
#define cID_LIM_COMP					(cOVC_COMP * 0.9f)	/* [A] d-axis limitation current */
#define cIQ_LIM_COMP					(11.0f)			/* [A] q-axis limitation current */
#define cINITIAL_POSITION_COMP			(0)				/* [deg] Initial position */

#if (cSHUNT_TYPE_COMP == 3)
#define cTRG_COMP_COMP					(0.0f)			/* [us] Trigger compensation time for 3shunt(for SoftVector). Setting range:0 <= x < (cPWMPRD_COMP/2) */
#else
#define cTRG_COMPEN_COMP				(-1.0f)			/* [us] Trigger compensation time for 1shunt(for SoftVector). Setting range:(-cPWMPRD_COMP/2) < x < (cPWMPRD_COMP/2) */
#define cTRGTIME0_COMP					(7.0f)			/* [us] 1st ADC Trigger Timing for Shift-2 PWM */
#define cTRGTIME1_COMP					(2.0f)			/* [us] 2nd ADC Trigger Timing for Shift-2 PWM */
#define cCOMPENSATION_VALUE0			(int32_t)((-0.5f)*FIX_15/cPWMPRD_COMP)	/* [us] 1st ADC Trigger Timing for normal PWM */
#define cCOMPENSATION_VALUE1			(int32_t)((-0.5f)*FIX_15/cPWMPRD_COMP)	/* [us] 2nd ADC Trigger Timing for normal PWM */
#endif

/*for Voltage control parameter */
#if defined(USE_COMP_MOTOR)
#define cVD_POS_COMP					(5.0f)			/* [V] Voltage of positioning */
#define cSPD_COEF_COMP					(0.14f)		    /* [-] Speed coefficient */
#define cHZ_V2I_COMP					(50.0f)			/* [Hz] Speed of switching from voltage control to current control */
#endif

/* for Encoder parameter */
#define cENC_PULSE_NUM_COMP 			(2048)			/* [ppr] Number of Encoder pulse */
#define cENC_DEG_ADJUST_COMP			(180)			/* [deg] Adjust Z-phase,0deg of electrical-angle */
#define cENC_NOISE_TIME_COMP			(0.1f)			/* [us] Encoder signal input noise cancel time. unit:fc/8 (for A-ENC only) */

/* for Fixed Vdc parameter */
#define cVDC_COMP						(141.0f)		/* [V] Power Voltage */

/*===================================================================*/

/* Control period of motor */
#define cCTRL_PRD_COMP					(cPWMPRD_COMP * cREPTIME_COMP * 1e-6)						/* [s] */
#define cSPD_CTRL_PRD_COMP				(cSPD_PI_PRD_COMP * cPWMPRD_COMP * cREPTIME_COMP * 1e-6)	/* [s] */
#define cPOWER_CAL_TIME 				(100)														/*no use*/

/* PFC start current */
#define cPFC_ON_CUR 					(0.5f)			/* [A] PFC ON current */

/* Power Calculation para setting */
#define cPOWER_LIMIT					(2200)			/* [W] MAX power */
#define cPOWER_EMG						(2400)			/* [W] MAX power */
#define cPOWER_FILTER					(20)			/* Power cal filter */
#define cPOWER_LINE1					(600)			/* [W] power compensate 1 */
#define cPOWER_LINE2					(1400)			/* [W] power compensate 2 */
#define cPOWER_LINE3					(2100)			/* [W] power compensate 3 */
#define cPOWER_COMPENSATE_FACTOR0		(0)				/* [W] power compenstate value 0 */
#define cPOWER_COMPENSATE_FACTOR1		(30)			/* [W] power compenstate value 1 */
#define cCOMPENSATE_MAX 				(100)			/* [W] power compensate max value */
#define cPOWER_DECREASE_SPD_FILTER		(250)											/* Power limit for decrase speed acc */					

/* Delta_theta Position compensation */
#define cDELTA_THETA_DIV				(28)													/* Delta theta divide para */
#define cDELTA_THATA_ON_SPD 			(35)													/* [HZ] Speed of start delta theta */
#define cDELTA_THATA_OFF_SPD			(120)													/* [HZ] Speed of stop delta theta */

/* ID/IQ filter change Parameter */
#define cDQ_FILTER_SPD_L				(90)													/* [HZ] Speed of Id/Iq filter change */
#define cDQ_FILTER_SPD_H				(180)													/* [HZ] Speed of Id/Iq filter change */

/*Ia/Ib/Ic fliter Parameter */
#define cCRITICAL_CUR1					(1)		    /* [A] Critical current parameter 1 */
#define cCRITICAL_CUR2					(2)		    /* [A] Critical current parameter 2 */
#define cCRITICAL_CUR3					(3)		    /* [A] Critical current parameter 3 */
#define cCRITICAL_CUR6					(6)		    /* [A] Critical current parameter 6 */
#define cCUR_JUDGE_CNT					(2)		    /* Judge a/b/c current error count */
#define cFILTER_STOP_SPD				(180)	    /* [HZ] Speed of stop a/b/c current filter */

#define cFILTERCONSTANT1				(1)
#define cFILTERCONSTANT2				(2)
#define cFILTERCONSTANT3				(3)
#define cFILTERCONSTANT5				(5)

/*===================================================================*/
/* temperature const para */
/*===================================================================*/
#define cOPEN							(10)		/* temperature detect open protect */
#define cSHORTC 						(4094)	    /* temperature detect short protect */
#define cOPEN_SHORT_CNT 				(50)		/* count times */
#define cTEMP_CNT						(10)		/* count times */
#define cTIMES							(10)		/* 0.1 cesius T */

#define cEXH_SL_UP						(80)		/* [C]outdoor exhaust temperature, speed slow up */
#define cEXH_NO_UP						(85)		/* [C]outdoor exhaust temperature, speed no increase */
#define cEXH_SL_DW						(95)		/* [C]outdoor exhaust temperature,speed slow down */
#define cEXH_OVER_EMG					(110)	    /* [C]outdoor exhaust temperature,over temperature EMG generate */

#define cHVMOS_SL_UP					(60)		/* [C]HVMOS temperature,speed slow up */
#define cHVMOS_NO_UP					(65)		/* [C]HVMOS temperature,speed no increase */
#define cHVMOS_SL_DW					(70)		/* [C]HVMOS temperature,speed slow down */
#define cHVMOS_OVER_EMG 				(90)		/* [C]HVMOS temperature,over temperature EMG generate */

#define cIGBT_SL_UP 					(60)		/* [C]IGBT temperature,speed slow up */
#define cIGBT_NO_UP 					(65)		/* [C]IGBT temperature,speed no increase */
#define cIGBT_SL_DW 					(70)		/* [C]IGBT temperature,speed slow down */
#define cIGBT_OVER_EMG					(90)		/* [C]IGBT temperature,over temperature EMG generate */

#define cDIODE_SL_UP					(60)		/* [C]DIODE temperature,speed slow up */
#define cDIODE_NO_UP					(65)		/* [C]DIODE temperature,speed no increase */
#define cDIODE_SL_DW					(70)		/* [C]DIODE temperature,speed slow down */
#define cDIODE_OVER_EMG 				(90)		/* [C]DIODE temperature,over temperature EMG generate */

#define cINPIPE_SL_UP					(50)		/* [C]INPIPE temperature,speed slow up */
#define cINPIPE_NO_UP					(53)		/* [C]INPIPE temperature,speed no increase */
#define cINPIPE_SL_DW					(55)		/* [C]INPIPE temperature,speed slow down */
#define cINPIPE_OVER_EMG				(65)		/* [C]INPIPE temperature,over temperature EMG generate */

#define cOUTPIPE_SL_UP					(45)		/* [C]OUTPIPE temperature,speed slow up. */
#define cOUTPIPE_NO_UP					(48)		/* [C]OUTPIPE temperature,speed no increase */
#define cOUTPIPE_SL_DW					(50)		/* [C]OUTPIPE temperature,speed slow down */
#define cOUTPIPE_OVER_EMG				(55)		/* [C]OUTPIPE temperature,over temperature EMG generate */
#define cTCF1							(3)		    /* [C]antifreezing degree */
#define cTCF0							(1)		    /* [C]antifreezing degree */

#define cTEMP_UP1						(150)	    /* [C] */
#define cTEMP_DW1						(-49)	    /* [C] */
#define cTEMP_DW2						(-17)	    /* [C] */
#define cOMEGA_DW_LIMIT 				(45)		/* [EHz] FL2 down limit speed for temperature */


/**************************************************************************************************************/
#define cRPS_MIN_COMP					(30.0f)	    /* [rps] Min speed */

/*===================================================================*
	Parameter check
 *===================================================================*/
#if (!((cPOLH_COMP == 0) || (cPOLH_COMP == 1)))
#error cPOLH_COMP define error. cPOLH_COMP only 0 or 1.
#endif

#if (!((cPOLL_COMP == 0) || (cPOLL_COMP == 1)))
#error cPOLL_COMP define error. cPOLL_COMP only 0 or 1.
#endif

#if (!((cSHUNT_TYPE_COMP == 1) || (cSHUNT_TYPE_COMP == 3)))
#error cSHUNT_TYPE_COMP define error. cSHUNT_TYPE_COMP only 1 or 3.
#endif

#if defined(__TYPE_LOW_VOLT) && defined(__TYPE_HIGH_VOLT)
#error __TYPE_LOW_VOLT or __TYPE_HIGH_VOLT define error.
#endif

#endif /* _D_PARA_COMP_H */

/*************************** END OF FILE **************************************/
