/**
 *******************************************************************************
 * @file    ipdrv_uart.h
 * @brief   This file provides all the functions prototypes for UART driver.
 * @version V0.1 (Tentative)
 * @date    2016/10/13
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LISENCE AGREEMENT.
 *
 * (C)Copyright TOSHIBA CORPORATION 2016 All rights reserved
 *******************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __IPDRV_UART_H
#define __IPDRV_UART_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
//-HIS_0001 #include "ipdrv_uart.h"
//+HIS_0001<s>
#include "TMPM4KyA.h"
//+HIS_0001<e>
#include "ipdrv_common.h"
//-HIS_0001 #include "TMPM4KLA.h"

/** @addtogroup TX04_Periph_Driver
  * @{
  */

/** @addtogroup UART
  * @{
  */

/** @defgroup UART_Exported_Types
  * @{
  */

/**
  * @brief  UART Init Structure definition
  */

    typedef struct {
        uint32_t BaudRate;              /*!< This member configures the UART communication
                                        baud rate. */
        uint32_t DataBits;              /*!< Specifies UART transfer mode, which could be
                                        7-bit mode, 8-bit mode or 9-bit mode. */
        uint32_t DataInvert;            /*!< Specifies Data inversion function of input/output data signal
                                        in UART mode. */
        uint32_t TransferDirection;     /*!< Specifies Data transfer direction LSB first or MSB first
                                        in UART mode. */
        uint32_t StopBits;              /*!< Specifies the length of stop bit transmission
                                        in UART mode. */
        uint32_t Parity;                /*!< Specifies the parity mode which could be odd
                                        parity, even parity or no parity. */
        uint32_t Mode;                  /*!< Enables or disables Receive, Transmit or
                                        both. */
        uint32_t FlowCtrl;              /*!< Specifies whether the hardware flow control
                                        mode is enabled or disabled. */
    } UART_InitTypeDef;

/** @} */
/* End of group UART_Exported_Types */

/** @defgroup UART_Exported_Constants
  * @{
  */

#define UART0  TSB_UART0
#define UART1  TSB_UART1
#define UART2  TSB_UART2
//#define UART3  TSB_UART3
//#define IS_UART_PERIPH(param)       (((param) == UART0) || \
                                 //   ((param) == UART1) || \
                                 //   ((param) == UART2) || \
                                 //   ((param) == UART3))
#define IS_UART_PERIPH(param)       (((param) == UART0) || \
                                    ((param) == UART1) || \
                                    ((param) == UART2) )

#define UART_DATA_BITS_7            ((uint32_t)0x00000000)
#define UART_DATA_BITS_8            ((uint32_t)0x00000001)
#define UART_DATA_BITS_9            ((uint32_t)0x00000002)
#define IS_UART_DATA_BITS(param)    (((param) == UART_DATA_BITS_7) || \
                                    ((param) == UART_DATA_BITS_8) || \
                                    ((param) == UART_DATA_BITS_9))

#define UART_STOP_BITS_1            ((uint32_t)0x00000000)
#define UART_STOP_BITS_2            ((uint32_t)0x00000010)
#define IS_UART_STOPBITS(param)     (((param) == UART_STOP_BITS_1) || \
                                    ((param) == UART_STOP_BITS_2))

#define UART_NO_PARITY              ((uint32_t)0x00000000)
#define UART_EVEN_PARITY            ((uint32_t)0x0000000C)
#define UART_ODD_PARITY             ((uint32_t)0x00000004)
#define IS_UART_PARITY(param)       (((param) == UART_NO_PARITY) || \
                                    ((param) == UART_EVEN_PARITY) || \
                                    ((param) == UART_ODD_PARITY))

#define UART_NO_DATA_INVERT         ((uint32_t)0x00000000)
#define UART_DATA_INVERT            ((uint32_t)0x00000040)
#define IS_UART_DATA_INVERT(param)  (((param) == UART_NO_DATA_INVERT) || \
                                    ((param) == UART_DATA_INVERT))

#define UART_ENABLE_RX              ((uint32_t)0x00000001)
#define UART_ENABLE_TX              ((uint32_t)0x00000002)
#define IS_UART_MODE(param)         (((param) == UART_ENABLE_RX) || \
                                    ((param) == UART_ENABLE_TX) || \
                                    ((param) == (UART_ENABLE_TX | UART_ENABLE_RX)))

#define UART_NONE_FLOW_CTRL         ((uint32_t)0x00000000)
#define IS_UART_FLOW_CONTROL(param) ((param) == UART_NONE_FLOW_CTRL)

//#define IS_UART_BAUDRATE(param)     (((param) >= 2400U) && \
                              //      ((param) <= 115200U))

#define IS_UART_BAUDRATE(param)     (((param) >= 150U) && \
                                    ((param) <= 115200U))
#define IS_UART_DATA(param)         ((param) <= 0x01FFU)

#define UART_LSB                    ((uint32_t)0x00000000)
#define UART_MSB                    ((uint32_t)0x00000020)
#define IS_UART_TRANSFER_DIR(param) (((param) == UART_LSB) || \
                                    ((param) == UART_MSB))

#define UART_RXFIFO_FLEVLE_8B              ((uint32_t)0x00000000)
#define UART_RXFIFO_FLEVLE_1B              ((uint32_t)0x00000100)
#define UART_RXFIFO_FLEVLE_2B              ((uint32_t)0x00000200)
#define UART_RXFIFO_FLEVLE_3B              ((uint32_t)0x00000300)
#define UART_RXFIFO_FLEVLE_4B              ((uint32_t)0x00000400)
#define UART_RXFIFO_FLEVLE_5B              ((uint32_t)0x00000500)
#define UART_RXFIFO_FLEVLE_6B              ((uint32_t)0x00000600)
#define UART_RXFIFO_FLEVLE_7B              ((uint32_t)0x00000700)
#define IS_UART_RXFIFO_FLEVLE(param)       (((param) == UART_RXFIFO_FLEVLE_8B) || \
                                           ((param) == UART_RXFIFO_FLEVLE_1B) || \
                                           ((param) == UART_RXFIFO_FLEVLE_2B) || \
                                           ((param) == UART_RXFIFO_FLEVLE_3B) || \
                                           ((param) == UART_RXFIFO_FLEVLE_4B) || \
                                           ((param) == UART_RXFIFO_FLEVLE_5B) || \
                                           ((param) == UART_RXFIFO_FLEVLE_6B) || \
                                           ((param) == UART_RXFIFO_FLEVLE_7B))

#define UART_TXFIFO_FLEVLE_0B              ((uint32_t)0x00000000)
#define UART_TXFIFO_FLEVLE_1B              ((uint32_t)0x00001000)
#define UART_TXFIFO_FLEVLE_2B              ((uint32_t)0x00002000)
#define UART_TXFIFO_FLEVLE_3B              ((uint32_t)0x00003000)
#define UART_TXFIFO_FLEVLE_4B              ((uint32_t)0x00004000)
#define UART_TXFIFO_FLEVLE_5B              ((uint32_t)0x00005000)
#define UART_TXFIFO_FLEVLE_6B              ((uint32_t)0x00006000)
#define UART_TXFIFO_FLEVLE_7B              ((uint32_t)0x00007000)
#define IS_UART_TXFIFO_FLEVLE(param)       (((param) == UART_TXFIFO_FLEVLE_0B) || \
                                           ((param) == UART_TXFIFO_FLEVLE_1B) || \
                                           ((param) == UART_TXFIFO_FLEVLE_2B) || \
                                           ((param) == UART_TXFIFO_FLEVLE_3B) || \
                                           ((param) == UART_TXFIFO_FLEVLE_4B) || \
                                           ((param) == UART_TXFIFO_FLEVLE_5B) || \
                                           ((param) == UART_TXFIFO_FLEVLE_6B) || \
                                           ((param) == UART_TXFIFO_FLEVLE_6B))

#define UART_RXFIFO_OVERRUN                ((uint32_t)0x00000001)

#define UART_OVERRUN_TYPE                  ((uint8_t)0x00)
#define UART_PARITY_ERR_TYPE               ((uint8_t)0x01)
#define UART_FRAMING_ERR_TYPE              ((uint8_t)0x02)
#define UART_TRIGGER_ERR_TYPE              ((uint8_t)0x03)
#define UART_BREAK_ERR_TYPE                ((uint8_t)0x04)
#define UART_ALL_ERR_TYPE                  ((uint8_t)0x05)
#define IS_UART_ERROR(param)               (((param) == UART_OVERRUN_TYPE) || \
                                           ((param) == UART_PARITY_ERR_TYPE) || \
                                           ((param) == UART_FRAMING_ERR_TYPE) || \
                                           ((param) == UART_TRIGGER_ERR_TYPE) || \
                                           ((param) == UART_BREAK_ERR_TYPE) || \
                                           ((param) == UART_ALL_ERR_TYPE))

#define UART_NO_TRANSMISSION               ((uint32_t)0x00000000)
#define UART_TRANSMISSION                  ((uint32_t)0x00000008)
#define IS_BREAK_TRANSMISSION(param)       (((param) == UART_NO_TRANSMISSION) || \
                                           ((param) == UART_TRANSMISSION))

#define ELIMINATION_TIME_NONE              ((uint32_t)0x00000000)
#define ELIMINATION_TIME_2_PHIT0           ((uint32_t)0x00001000)
#define ELIMINATION_TIME_4_PHIT0           ((uint32_t)0x00002000)
#define ELIMINATION_TIME_8_PHIT0           ((uint32_t)0x00003000)
#define ELIMINATION_TIME_2_TRANSFERCLK     ((uint32_t)0x00004000)
#define ELIMINATION_TIME_3_TRANSFERCLK     ((uint32_t)0x00005000)
#define ELIMINATION_TIME_4_TRANSFERCLK     ((uint32_t)0x00006000)
#define ELIMINATION_TIME_5_TRANSFERCLK     ((uint32_t)0x00007000)
#define IS_NOISE_ELIMINATION_TIME(param)   (((param) == ELIMINATION_TIME_NONE) || \
                                           ((param) == ELIMINATION_TIME_2_PHIT0) || \
                                           ((param) == ELIMINATION_TIME_4_PHIT0) || \
                                           ((param) == ELIMINATION_TIME_8_PHIT0) || \
                                           ((param) == ELIMINATION_TIME_2_TRANSFERCLK) || \
                                           ((param) == ELIMINATION_TIME_3_TRANSFERCLK) || \
                                           ((param) == ELIMINATION_TIME_4_TRANSFERCLK) || \
                                           ((param) == ELIMINATION_TIME_5_TRANSFERCLK))

/** @} */
/* End of group UART_Exported_Constants */
/** @addtogroup UART_Exported_Types
  * @{
  */
    typedef enum {
        UART_NO_ERR = 0U,
        UART_OVERRUN = 1U,
        UART_PARITY_ERR = 2U,
        UART_FRAMING_ERR = 3U,
        UART_TRIGGER_ERR = 4U,
        UART_BREAK_ERR = 5U,
        UART_ERRS = 6U
    } UART_Err;

    typedef enum {
        UART_RECEPTION = 0U,
        UART_TRANSMIT = 1U,
    } Uart_TransferMode;
#define IS_UART_TRANSFER_MODE(param)            ((param) <= UART_TRANSMIT)

    typedef enum {
        PROGRAMMABLE = 0U,
        NOT_PROGRAMMABLE = 1U,
    } Register_Flag;

    typedef enum {
        IN_PROGRESS = 0U,
        COMPLETED = 1U,
    } Transfer_Status;

    typedef enum {
        NO_REACH_FLEVEL= 0U,
        REACH_FLEVEL = 1U,
    } FIFO_Status;
/** @} */
/* End of group UART_Exported_Types */

/** @defgroup UART_Exported_FunctionPrototypes
  * @{
  */

    static Register_Flag UART_GetStatusEnableFlag(TSB_UART_TypeDef * UARTx );
    void UART_SWReset(TSB_UART_TypeDef * UARTx);
    Result UART_Init(TSB_UART_TypeDef * UARTx, UART_InitTypeDef * InitStruct);
    uint32_t UART_GetRxData(TSB_UART_TypeDef * UARTx);
    void UART_SetTxData(TSB_UART_TypeDef * UARTx, uint32_t Data);
    Result UART_DefaultConfig(TSB_UART_TypeDef * UARTx);
    UART_Err UART_GetErrState(TSB_UART_TypeDef * UARTx);
    Result UART_ClearErrState(TSB_UART_TypeDef * UARTx, uint8_t ErrorType);
    Result UART_SetWakeUpFunc(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_SetLoopBackFunc(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_SetNoiseEliminateTime(TSB_UART_TypeDef * UARTx, uint32_t Elimination_Time);
    void UART_SetBreakTransmission(TSB_UART_TypeDef * UARTx, uint32_t breakmode);
    void UART_SetTriggerTransmission(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_RxHandshakeFunc(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_TxHandshakeFunc(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_RxFIFOINTCtrl(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_TxFIFOINTCtrl(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_RxFIFOFillLevel(TSB_UART_TypeDef * UARTx, uint32_t RxFIFOLevel);
    Result UART_TxFIFOFillLevel(TSB_UART_TypeDef * UARTx, uint32_t TxFIFOLevel);
    Result UART_RxFIFOClear(TSB_UART_TypeDef * UARTx);
    Result UART_TxFIFOClear(TSB_UART_TypeDef * UARTx);
    Result UART_RxINTCtrl(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_TxINTCtrl(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_ErrINTCtrl(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_RxDMACtrl(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Result UART_TxDMACtrl(TSB_UART_TypeDef * UARTx, FunctionalState NewState);
    Transfer_Status UART_GetTransferStatus(TSB_UART_TypeDef * UARTx, Uart_TransferMode Transfer_Mode);
    FIFO_Status UART_GetFIFOStatus(TSB_UART_TypeDef * UARTx, Uart_TransferMode Transfer_Mode);
    uint32_t UART_GetRxFIFOFillLevelStatus(TSB_UART_TypeDef * UARTx);
    uint32_t UART_GetTxFIFOFillLevelStatus(TSB_UART_TypeDef * UARTx);
    void UART_ClearTransferStatus(TSB_UART_TypeDef * UARTx, Uart_TransferMode Transfer_Mode);
    void UART_ClearFIFOStatus(TSB_UART_TypeDef * UARTx, Uart_TransferMode Transfer_Mode);

/** @} */
/* End of group UART_Exported_FunctionPrototypes */

/** @} */
/* End of group UART */

/** @} */
/* End of group TX04_Periph_Driver */

#ifdef __cplusplus
}
#endif                          /* __cplusplus */
#endif                          /* __TMPM4K4_UART_H */
