/**
 ****************************************************************************
 * @file     E_Sub.h
 * @brief    Sub Routine Functions
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _E_SUB_H_INCLUDED
#define _E_SUB_H_INCLUDED

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif
#define cCAL_FACTOR (0x7FFFFFFF)

/*===================================================================*
      Proto Type Definition
 *===================================================================*/
EXTERN short E_Sine(short theta);
EXTERN short E_Cosine(short theta);
EXTERN void E_Clarke(q15_t _iu, q15_t _iv, q15_t _iw, q15_t * _ialpha, q15_t * _ibeta);
EXTERN void E_Park(q15_t _ialpha, q15_t _ibeta, uint16_t _theta, q15_t * _id, q15_t * _iq);
EXTERN void E_InvPark(q31_t _d, q31_t _q, uint16_t _theta, q31_t * _alpha, q31_t * _beta);
EXTERN int32_t E_Max3(int32_t _a, int32_t _b, int32_t _c);
EXTERN int32_t E_Med3(int32_t _a, int32_t _b, int32_t _c);
EXTERN int32_t E_Min3(int32_t _a, int32_t _b, int32_t _c);
EXTERN void E_Sort3(int32_t * _n1, int32_t * _n2, int32_t * _n3);
EXTERN q31_t C_E_Sqrt(int32_t data_s);
EXTERN q31_t C_muljc(q31_t r1, q31_t c1);
EXTERN q31_t muljc(q31_t r1, q31_t c1);
EXTERN q31_t smul32(q31_t a, q31_t b);
EXTERN int32_t Limit_sub(int64_t _indata, int32_t _limlo, int32_t _limup);
EXTERN uint32_t U_C_command_limit_sub(uint32_t _now, uint32_t _target, uint32_t _lim_up, uint32_t _lim_down);
#undef	EXTERN
#endif				/* _E_SUB_H_INCLUDED */

/*********************************** END OF FILE ******************************/
