/**
 ****************************************************************************
 * @file:	 dac_drv.h
 * @brief:	 DAC IC Control for AD5624 on TSPI.
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _DACDRV_H
#define _DACDRV_H

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif

/*===================================================================*
  Macro Definition
 *===================================================================*/

/* Setting ~SYNC port */
#define PORT_DAC_SYNC				TSB_PG_DATA_PG4
#define PORT_DAC_SYNC_DATA_INI		(TSB_PG->DATA |= (1 << 4u))
#define PORT_DAC_SYNC_CR_INI		(TSB_PG->CR |= (1 << 4u))

/* Setting TSPI */
#define DAC_SIO_CH					TSB_TSPI1
#define DAC_IRQ_INTTX				INTSC1TX_IRQn

#define DAC_IRQ_LEVEL				INT_DAC_LEVEL
#define DAC_MAX_CH					4					/* MAX channel */


/*===================================================================*
  Definition of variable
 *===================================================================*/
EXTERN	uint16_t	DacData[4];


/*===================================================================*
  Proto Type Definition
 *===================================================================*/
EXTERN	void	init_Dac(TSB_TSPI_TypeDef * const TSPIx);
EXTERN	void	DacWriteStart(TSB_TSPI_TypeDef * const TSPIx);
EXTERN	void	DacWriteContinue(TSB_TSPI_TypeDef * const TSPIx);

#undef EXTERN
#endif  /* _DACDRV_H */


/*************************** END OF FILE **************************************/
