/**
 ****************************************************************************
 * @file     main.c
 * @brief    main Functions
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#include <stdlib.h>

#define DEFINE_APP
#include "ipdefine.h"
#undef	DEFINE_APP
#include "mcuip_drv.h"

#include "D_Driver.h"
#include "C_Control.h"
#include "B_User.h"
#include "initial.h"
#include "usercon.h"
#include "dac_drv.h"

/*===================================================================*
	Proto Type Definition
 *===================================================================*/
void main_loop(void);

/*===================================================================*
	Function
 *===================================================================*/

/**
 *********************************************************************************************
 * @brief		main Routine
 *
 * @return		int
 *********************************************************************************************
 */
int main(void)
{

	/***** Initial Setting *****/
	__disable_irq();									/* DI */

	init_WDT();											/* Initial setting of WDT */

	init_Timer_interval4kH();							/* Initial setting of interval timer. */

	init_ADCen();										/* Initial setting of ADC */
	init_PMDen();										/* Initial setting of PMD */
	init_VEen();										/* Initial setting of VE & start */

	B_Motor_Init();										/* Initial setting of the motor control. */
	init_user_control();								/* Initial setting of user control. */

#if defined(__USE_DAC)
	init_Dac(DAC_SIO_CH);								/* Initial setting of Dac controller */
#endif /* __USE_DAC */

	__enable_irq(); 									/* EI */

	UikeyInitscan();

	WDT_WriteClearCode();

	/***** Main Loop *****/
	main_loop();

	return 0;
}

/**
 *********************************************************************************************
 * @brief		main_loop
 *
 * @return		none
 *********************************************************************************************
 */
void main_loop(void)
{
	while (1)
	{
		if (M_Main_Counter >= cMAINLOOP_CNT)
		{
			vector_t* motor_ch;
			M_Main_Counter = 0;

			/***** Clear WDT *****/
			WDT_WriteClearCode();

			/***** User control *****/
			user_control();

			/***** User motor control	*****/
			B_User_MotorControl();

			/***** Motor control  *****/
			motor_ch = &Motor_ch1;

			D_SetZeroCurrentByVE(motor_ch, &Motor_ch1_IP);	/* Set Zero current */
			C_Control_Ref_Model(motor_ch);				/* Change of stage */
			C_Common(motor_ch); 						/* Stage Functions */
			C_Stage_Stop(motor_ch); 					/* Stop */
			C_Stage_Emergency(motor_ch);				/* Emargency */
			C_Stage_Bootstrap(motor_ch);				/* Positioning */
			C_Stage_Initposition(motor_ch); 			/* Bootstrap */
			C_Stage_Force(motor_ch);					/* Force commutation */
			C_Stage_Change_up(motor_ch);				/* Change up */
			C_Stage_Steady_A(motor_ch); 				/* Normal RUN A (Speed control by currnt) */


			uart_control();

		}
	}
}


/*********************************** END OF FILE ******************************/
