/**
 ****************************************************************************
 * @file     ipdrv.h
 * @brief    IP Driver Commonization definition
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _IPDRV_H
#define _IPDRV_H

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM4J5_H__)
 #include "ipdrv_adc_M4J5.h"
 #include "ipdrv_cg_M4J5.h"
 #include "ipdrv_enc_M4J5.h"
 #include "ipdrv_siwdt_M4J5.h"
 #include "ipdrv_tspi_M4J5.h"
 #include "ipdrv_t32a_M4J5.h"
#endif /* defined(__TMPM4J5_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM4L2_H__)
 #include "ipdrv_adc_M4L2.h"
 #include "ipdrv_cg_M4L2.h"
 #include "ipdrv_enc_M4L2.h"
 #include "ipdrv_siwdt_M4L2.h"
 #include "ipdrv_tspi_M4L2.h"
 #include "ipdrv_t32a_M4L2.h"
#endif /* defined(__TMPM4L2_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM4KN_H__)
 #include "ipdrv_adc.h"
 #include "ipdrv_cg.h"
 #include "ipdrv_enc.h"
 #include "ipdrv_siwdt.h"
 #include "ipdrv_tspi.h"
 #include "ipdrv_t32a.h"
#endif /* defined(__TMPM4KN_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM4K4A_H__)
 #include "ipdrv_adc.h"
 #include "ipdrv_cg.h"
 #include "ipdrv_enc.h"
 #include "ipdrv_siwdt.h"
 #include "ipdrv_tspi.h"
 #include "ipdrv_t32a.h"
#endif /* defined(__TMPM4K4A_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM470_H__)
 #include "tmpm470_adc.h"
 #include "tmpm470_enc.h"
 #include "tmpm470_gpio.h"
 #include "tmpm470_tmrb.h"
 #include "tmpm470_uart.h"
 #include "tmpm470_wdt.h"
#endif /* defined(__TMPM470_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM475_H__)
 #include "tmpm475_adc.h"
 #include "tmpm475_enc.h"
 #include "tmpm475_gpio.h"
 #include "tmpm475_tmrb.h"
 #include "tmpm475_uart.h"
 #include "tmpm475_wdt.h"
#endif /* defined(__TMPM475_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM375_H__)
 #include "tmpm375_adc.h"
 #include "tmpm375_enc.h"
 #include "tmpm375_gpio.h"
 #include "tmpm375_tmrb.h"
 #include "tmpm375_uart.h"
 #include "tmpm375_wdt.h"
#endif /* defined(__TMPM375_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM370_H__)
 #include "tmpm370_adc.h"
 #include "tmpm370_enc.h"
 #include "tmpm370_gpio.h"
 #include "tmpm370_tmrb.h"
 #include "tmpm370_uart.h"
 #include "tmpm370_wdt.h"
#endif /* defined(__TMPM370_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM372_H__)
 #include "tmpm372_adc.h"
 #include "tmpm372_enc.h"
 #include "tmpm372_gpio.h"
 #include "tmpm372_tmrb.h"
 #include "tmpm372_uart.h"
 #include "tmpm372_wdt.h"
#endif /* defined(__TMPM372_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM373_H__)
 #include "tmpm373_adc.h"
 #include "tmpm373_enc.h"
 #include "tmpm373_gpio.h"
 #include "tmpm373_tmrb.h"
 #include "tmpm373_uart.h"
 #include "tmpm373_wdt.h"
#endif /* defined(__TMPM373_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM374_H__)
 #include "tmpm374_adc.h"
 #include "tmpm374_gpio.h"
 #include "tmpm374_tmrb.h"
 #include "tmpm374_uart.h"
 #include "tmpm374_wdt.h"
#endif /* defined(__TMPM374_H__) */

/*===================================================================*
  Includes
 *===================================================================*/
#if defined(__TMPM376_H__)
 #include "tmpm376_adc.h"
 #include "tmpm376_enc.h"
 #include "tmpm376_gpio.h"
 #include "tmpm376_tmrb.h"
 #include "tmpm376_uart.h"
 #include "tmpm376_wdt.h"
#endif /* defined(__TMPM376_H__) */

/*===================================================================*
  Structure Definition
 *===================================================================*/
typedef struct
{
	TSB_VE_TypeDef* const VEx;
	TSB_PMD_TypeDef* const PMDx;
	TSB_AD_TypeDef* const ADx;
} ipdrv_t;

/*===================================================================*
  External Reference Definition
 *===================================================================*/
extern const ipdrv_t Motor_ch1_IP;

#endif /* _IPDRV_H */
/*************************** END OF FILE **************************************/
