###########################################################################
#
#  Design Gateway
#
#  Component Browser [ System Resource File ] in Japanese.
#
###########################################################################
# displayString : R|[lguEU\[Xt@C

## Reference Group
##---------------------------------------------------
ReferenceGroup {
	(
		"L"
		"IC"
		"FL"
		"D"
		"Q"
		"C"
		"R"
		"S"
		"J"
		"T"
		"X"
	)
}

## Property Display List
##--------------------------------------------------
PropertyList {
  ("CMP_PROP_LIST"	reference partName value partNumber)
  ("PARTS_PROP_LIST"	partNumber partName value)
  ("VAR_PROP_LIST"	cdbName componentName noMount)
}

## VariationItem Display List
##--------------------------------------------------
VariationItemList {
  ("Voltage"	 100V 200V)
}

## Variation Type List
##--------------------------------------------------
VariationTypeList {
  ("Audio/Voltage"      Audio Voltage)
}

## Destination Display List
##--------------------------------------------------
#DestinationList {
#  ("Destination"	 JPN-A JPN-B)
#}


## Search List
##---------------------------------------------------
SearchList {
  ("reference == IC or C"	"(reference pattern IC*)+(reference pattern C*)")
  ("value >= 0.1"		"(value >= double 0.1)")
  ("sample"			"(partNumber empty)*[(function string registor)+(function string tr)]")
  ("E-1"			"(value significant 1.0)")
  ("E-3"			"(value significant 1.0                             2.2                             4.7)")
  ("E-6"			"(value significant 1.0             1.5             2.2             3.3             4.7             6.8)")
  ("E-12"			"(value significant 1.0     1.2     1.5     1.8     2.2     2.7     3.3     3.9     4.7     5.6     6.8 7.5 8.2)")
  ("E-24"			"(value significant 1.0 1.1 1.2 1.3 1.5 1.6 1.8 2.0 2.2 2.4 2.7 3.0 3.3 3.6 3.9 4.3 4.7 5.1 5.6 6.2 6.8 7.5 8.2 9.1)")
}

## Sort List
##---------------------------------------------------
SortList {
  ("reference ascending"	"(reference Ascending)")
  ("value descending"		"(value Descending)")
}

##
## Display Format ("FormatName" "DisplayMode" "PropertyList" "SearchList" "SortList")
##---------------------------------------------------
DisplayFormat {
  ("value >= 0.1"		"Component"		"CMP_PROP_LIST"		"value >= 0.1"		"value descending")
  ("Parts Format Sample"	"Parts*reference"	"PARTS_PROP_LIST"	"reference == IC or C"	"reference ascending")
  ("Variation Format Sample"	"Variation*Voltage"	"VAR_PROP_LIST"		""			"reference ascending")
  ("Default Format"		"Parts*reference"	"PARTS_PROP_LIST"	""			"")
}

##
## Default Display Format
##---------------------------------------------------
#DefaultDisplayFormat : "Default Format"

## Mark Color
##---------------------------------------------------
#NoMountColor : Pink
#ToBoardColor : LightBlue
#DestSynchColor : LemonChiffon
DestDiffColor : DeepPink

##
## Destination Variation List Option
##---------------------------------------------------
DestinationMode-ViewAllComponent : "DestinationPart"

##
## Grouping Frame Key Property
##---------------------------------------------------
FrameKeyProperty{
  ("Grouping"	compGroup)
}

##
## Group Tree Separator
##---------------------------------------------------
#GroupSeparator : "\\"
#GroupingFrameStyle : "Nest"

##
## Group Tree Display Style
##---------------------------------------------------
FrmBlkTreeDispStyle : "Frame"

##
## Detail Settings
##---------------------------------------------------
StartAllSheet : "False"
ZoomAdjust : "True"
EtoC_Mode : "noChange"      # noChange, Standard, Reference
MarkVariation : "noMark"    # noMark, toBoard, noMount
MarkDestNoMount : "False"
MarkDestSynch : "False"
StartCreateFrmGrp : "False"
GrpUndoRedo : "False"
ViewNoKeyPropComp : "FALSE"

##
## MatrixView Settings
##---------------------------------------------------
MatrixDispKeyName : "On"
MatrixMountChar : "1"
MatrixNoMountChar : "0"
MatrixVmLabelSeparateChar : ""
MatrixVariationMode-ViewAllComponent : "False"
MatrixDestinationMode-ViewAllComponent : "True"

##
## Dest Special Copy Mode
##---------------------------------------------------
DestSpecialCopyMode : "Off"

##
## Diff Property Name
##---------------------------------------------------
DiffPropertyName {
	(
		"partName"
		"noMount"
	)
}

